#!/bin/sh

# swapfilesize
swapsize=512

# does the swap file already exist?
grep -q "swapfile" /etc/fstab

# if not then create it
if [ $? -ne 0 ]; then
	echo 'swapfile not found. Adding swapfile.'
        dd if=/dev/zero of=/swapfile count=524288 bs=1024
        ls -lh /swapfile
	chmod 600 /swapfile
        ls -lh /swapfile
	mkswap /swapfile
	swapon /swapfile
        swapon -s
	echo '/swapfile none swap defaults 0 0' >> /etc/fstab
else
	echo 'swapfile found. No changes made.'
fi

# output results to terminal

echo "output results to terminal for swaps and meminfo"
cat /proc/swaps
cat /proc/meminfo | grep Swap
